VERSION 5.00
Begin VB.Form frmGPIBSettings 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "GPIB Settings for 2510 Demo"
   ClientHeight    =   6315
   ClientLeft      =   3990
   ClientTop       =   2985
   ClientWidth     =   5475
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6315
   ScaleWidth      =   5475
   ShowInTaskbar   =   0   'False
   Begin VB.TextBox txtInstructions 
      Appearance      =   0  'Flat
      BackColor       =   &H80000000&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   240
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      TabIndex        =   16
      Text            =   "frmGPIBSettings.frx":0000
      Top             =   480
      Width           =   4935
   End
   Begin VB.Frame Frame2 
      Caption         =   "Instrument"
      Height          =   2415
      Left            =   240
      TabIndex        =   7
      Top             =   3000
      Width           =   3135
      Begin VB.TextBox txt2510GPIB 
         Alignment       =   2  'Center
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   315
         Left            =   1440
         TabIndex        =   2
         Text            =   "15"
         Top             =   360
         Width           =   372
      End
      Begin VB.CommandButton cmdTestUnit 
         Caption         =   "Query ID"
         Height          =   495
         Left            =   2160
         TabIndex        =   15
         Top             =   240
         Width           =   795
      End
      Begin VB.TextBox txtModelNum 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   288
         Left            =   1440
         Locked          =   -1  'True
         TabIndex        =   14
         Top             =   960
         Width           =   1452
      End
      Begin VB.TextBox txtFWRev 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   288
         Left            =   1440
         Locked          =   -1  'True
         TabIndex        =   13
         Top             =   1440
         Width           =   612
      End
      Begin VB.TextBox txtSerialNum 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   288
         Left            =   1440
         Locked          =   -1  'True
         TabIndex        =   12
         Top             =   1920
         Width           =   732
      End
      Begin VB.Label Label2 
         Caption         =   "Serial Number"
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   1920
         Width           =   1095
      End
      Begin VB.Label Label9 
         Caption         =   "Firmware Rev "
         Height          =   255
         Left            =   240
         TabIndex        =   10
         Top             =   1440
         Width           =   1095
      End
      Begin VB.Label Label10 
         Caption         =   "Model"
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   960
         Width           =   495
      End
      Begin VB.Label lblGPIBAddr 
         Caption         =   "GPIB Address"
         Height          =   255
         Left            =   240
         TabIndex        =   8
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.CommandButton cmdSaveSettings 
      Caption         =   "Save GPIB Settings"
      Height          =   495
      Left            =   3720
      TabIndex        =   6
      Top             =   3000
      Width           =   1215
   End
   Begin VB.Frame fraGPIBCard 
      Caption         =   "GPIB Card"
      Height          =   930
      Left            =   240
      TabIndex        =   3
      Top             =   1920
      Width           =   1965
      Begin VB.OptionButton CommOpt 
         Caption         =   "Keithley/CEC"
         Height          =   252
         Index           =   0
         Left            =   72
         TabIndex        =   5
         Top             =   240
         Width           =   1620
      End
      Begin VB.OptionButton CommOpt 
         Caption         =   "National Instruments"
         Height          =   252
         Index           =   1
         Left            =   72
         TabIndex        =   4
         Top             =   550
         Width           =   1740
      End
   End
   Begin VB.CommandButton cmdCancelGPIB 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3720
      TabIndex        =   1
      Top             =   2520
      Width           =   1215
   End
   Begin VB.CommandButton cmdOKGPIB 
      Caption         =   "OK"
      Height          =   375
      Left            =   3720
      TabIndex        =   0
      Top             =   2040
      Width           =   1215
   End
   Begin VB.Image Image3 
      Appearance      =   0  'Flat
      Height          =   585
      Left            =   2520
      Picture         =   "frmGPIBSettings.frx":0006
      Stretch         =   -1  'True
      Top             =   5640
      Width           =   2700
   End
   Begin VB.Label Label1 
      Caption         =   "Instructions"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   17
      Top             =   240
      Width           =   2175
   End
End
Attribute VB_Name = "frmGPIBSettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This forms contains the GPIB settings (Address, card) for the
'instrument, which must be chosen before the program will continue to the main form

Option Explicit

Public stridn As String           'string for ID string of instrument

Private Sub cmdCancelGPIB_Click()
'Program cancel request

If (intModel = int2510AT) Or (intModel = int2510) Then      'If model is a 2510 or 2510AT, then go to main program
    frmGPIBSettings.Hide
    Else
    Unload frmGPIBSettings                      'If model type is other, quit program
End If

End Sub

Private Sub cmdSaveSettings_Click()
'Determine card type chosen, then save to a file in same diretory as demo program

'MsgBox "Saving the GPIB card type will prevent you from having to choose the card type every time you use this program."

If CommOpt(0).value Then
    strCard = "CEC"
    Else
    strCard = "NI"
End If

Call StoreSetting(strSetFile)

End Sub

Private Sub CommOpt_Click(Index As Integer)
'Make sure a card is chosen upon program load
'OR that the configuration control file exists
'Also, initialize GPIB card when card choice is made

CheckGPIBCard                               'Enable controls

'Initialize GPIB Card
Select Case Index

    Case 0          'Initialize CEC Card
            gintCommType = CEC                  'Set global variable for card/communication method
        
    Case 1          'Initialize NI Card
            gintCommType = NI                   'Set global variable for card/communication method

End Select

Call GPIBInitialize(10000)                  'Initialize GPIB card

End Sub

Private Sub Form_Load()
'Grab/display values, reset controls

'If Not blnSetFile Then
    txt2510GPIB.Text = intKI2510            'Copy instrument GPIB address to text window
'End If

Call CheckGPIBCard              'Dis/Enable OK & Cancel buttons

'Set instructions text box
txtInstructions.Text = "1.  Choose GPIB card" & vbCrLf _
                        & "2.  Enter 2510-AT/2510 GPIB address" & vbCrLf _
                        & "3.  Press ""Query ID"" button" & vbCrLf _
                        & "4.  Choose ""Go Autotune"" for 2510-AT " & vbCrLf _
                        & "      or ""Go Control Temp"" for 2510."

'Set tool tip text for various controls on form
cmdSaveSettings.ToolTipText = "Click here to save the GPIB card and address settings to " & strSetFile & _
                                ", eliminating the need to re-enter this data again."
CommOpt(0).ToolTipText = "Keithley/CEC KPC-488.2 card"
CommOpt(1).ToolTipText = "NI-488.2M card"
'cmd2510IDN.ToolTipText = "Sends GPIB command ""*IDN?"" to instrument."
cmdTestUnit.ToolTipText = "Checks for proper communication by sending GPIB command ""*IDN?"" to instrument."
fraGPIBCard.ToolTipText = "Please select the GPIB card to use."

End Sub

Private Sub cmdOKGPIB_Click()
'Transfer GPIB address, reset text boxes and close frmGPIBSettings

frmGPIBSettings.Hide
'txt2510Output.Text = ""                 'Reset output window
intKI2510 = txt2510GPIB.Text            'Copy GPIB address from txtbox to variable
If intModel = int2510AT Then
'    Call cmdTestUnit_Click
'    frmPIDStep.Hide
    frmAutotune.Show
'    frmPIDStep.optPID(1).Visible = True        'Display Min Settle time button
'    frmPIDStep.txtMSETKp.Visible = True        'Display Min settle coeff
'    frmPIDStep.txtMSETKi.Visible = True        'Display Min settle coeff
'    frmPIDStep.txtMSETKd.Visible = True        'Display Min settle coeff
'    frmPIDStep.optPID(2).Visible = True        'Display Min overshoot button
'    frmPIDStep.txtMOVKp.Visible = True         'Display Min overshoot coeff
'    frmPIDStep.txtMOVKi.Visible = True         'Display Min overshoot coeff
'    frmPIDStep.txtMOVKd.Visible = True         'Display Min overshoot coeff
    
    ElseIf intModel = int2510 Then  'If not AT, then just show PID temp step form
    
    frmPIDStep.Show                 'Display PID Temp Step form
    frmAutotune.Hide                'Hide Autotune, since 2510 doesn't support it
'    Call frmPIDStep.cmdGetPresentPID_Click       'Get PIDs stored in instrument
'    frmPIDStep.optPID(0).value = True          'Choose Present PID
'    'Hide autotune-oriented stuff (MSET & MOV PIDs, etc)
'    frmPIDStep.optPID(1).Visible = False       'Hide Min Settle time button
'    frmPIDStep.txtMSETKp.Visible = False       'Hide Min settle coeff
'    frmPIDStep.txtMSETKi.Visible = False       'Hide Min settle coeff
'    frmPIDStep.txtMSETKd.Visible = False       'Hide Min settle coeff
'    frmPIDStep.optPID(2).Visible = False       'Hide Min overshoot button
'    frmPIDStep.txtMOVKp.Visible = False        'Hide Min overshoot coeff
'    frmPIDStep.txtMOVKi.Visible = False        'Hide Min overshoot coeff
'    frmPIDStep.txtMOVKd.Visible = False        'Hide Min overshoot coeff
    
End If

End Sub

Public Sub CheckGPIBCard()
'Makes sure that one GPIB card type is chosen
'before enabling the Cancel button
'Note:  OK and save buttons enabled after successful check of the type
'of instrument (2510 or 2510-AT will enable demo to continue)

'If no GPIB card is chosen, disable the OK, cancel and Save buttons
If CommOpt(0).value Or CommOpt(1).value Then    'One card chosen, enable buttons
'    cmdOKGPIB.Enabled = True
'    cmdCancelGPIB.Enabled = True
'    cmdSaveSettings.Enabled = True
    cmdTestUnit.Enabled = True
    Else                        'Neither card chosen
    cmdOKGPIB.Enabled = False
'    cmdCancelGPIB.Enabled = False
    cmdSaveSettings.Enabled = False
    cmdTestUnit.Enabled = False
End If

End Sub

Public Sub cmdTestUnit_Click()
'Get *IDN? String and determine if 2510 or 2510-AT is there - Get *IDN? String

Dim lth As Integer
Dim strFWrev As String              '2510 Firmware revision string
Dim arraystrIDN() As String         'Parsed IDN string

stridn = Space$(127)
If SendKI(txt2510GPIB.Text, "*IDN?") Then Exit Sub  'Query IDN string of instrument
stridn = QueryKI(txt2510GPIB.Text)                  'Retrieve data

'Parse instrument IDN string

arraystrIDN = Split(stridn, ",")                   'Split the IDN string into 4 pieces, based on comma delimeter
txtModelNum.Text = arraystrIDN(1)
strFWrev = Mid(arraystrIDN(3), 2, 4)               'Chop off leading character (hardware rev) of revision
sngFWRev = Val(Mid(arraystrIDN(3), 2, 4))           'Chop off leading hardware rev character, then convert string to a number
txtFWRev.Text = Left(arraystrIDN(3), 5)             'Display Firmware rev, including leading character
txtSerialNum.Text = arraystrIDN(2)


'if not a 2510-AT or 2510, stop the bus here!
'If (txtModelNum.Text <> "MODEL 2510-AT") And (txtModelNum.Text <> "Model 2510") Then
'    cmdAutotune.Enabled = False
'    fraTuningMethod.Enabled = False
'    fraTauValue.Enabled = False
'    txtStartTemp.Enabled = False
'    txtStopTemp.Enabled = False
'    txtCurrProt.Enabled = False
'    txtVoltProt.Enabled = False
'    txtUppLim.Enabled = False
'    txtLowLim.Enabled = False
'    MsgBox "It's NOT a 2510 AT !!!"
'    intModel = intOther                 'Set model type to Other
'    set model # to red
'    txtModelNum.BackColor = &H1111FF
'    GoTo fino
'End If
'
If txtModelNum.Text = "MODEL 2510-AT" Then
    If (sngFWRev >= 7) Or (strFWrev = "XX.X") Then
        'set model type to 2510AT
        intModel = int2510AT
        'set model # text field to green
        txtModelNum.BackColor = &H11FF11
        'set fwrev color to white
        txtFWRev.BackColor = &HFFFFFF
        'cmdAutotune.Enabled = True
        'fraTuningMethod.Enabled = True
        'fraTauValue.Enabled = True
        'txtStartTemp.Enabled = True
        'txtStopTemp.Enabled = True
        'txtCurrProt.Enabled = True
        'txtVoltProt.Enabled = True
        'txtUppLim.Enabled = True
        'txtLowLim.Enabled = True
        cmdOKGPIB.Enabled = True
        cmdOKGPIB.Caption = "Go Autotune!"
        cmdCancelGPIB.Enabled = True
        cmdSaveSettings.Enabled = True
        GoTo fino
        Else
'If strFWrev = "XX.X " Then GoTo ok2510AT
'If sngFWRev < 7 Then        '2510-AT firmware must be at least 7 for this demo program to work
'    cmdAutotune.Enabled = False
'    fraTuningMethod.Enabled = False
'    fraTauValue.Enabled = False
'    txtStartTemp.Enabled = False
'    txtStopTemp.Enabled = False
'    txtCurrProt.Enabled = False
'    txtVoltProt.Enabled = False
'    txtUppLim.Enabled = False
'    txtLowLim.Enabled = False
    MsgBox "2510-AT Firmware rev. less than 7, which is not supported by this demo program."

    'set FWRev background to red
    txtFWRev.BackColor = &H1111FF
    GoTo other
    End If
End If

If txtModelNum.Text = "MODEL 2510" Then
    'set model type to 2510
    intModel = int2510
    txtModelNum.BackColor = &HCAFFCA        'set model # text field to light green
    txtFWRev.BackColor = &HFFFFFF           'set fwrev color to white
    cmdOKGPIB.Enabled = True
    cmdOKGPIB.Caption = "Go Control Temp"
    cmdCancelGPIB.Enabled = True
    cmdSaveSettings.Enabled = True
    Else: GoTo other
End If

Exit Sub

ok2510AT:                   '2510-AT is an autotune model with good firmware
'    'set model type to 2510AT
'    intModel = int2510AT
'    'set model # text field to green
'    txtModelNum.BackColor = &H11FF11
'    'set fwrev color to white
'    txtFWRev.BackColor = &HFFFFFF
'    'cmdAutotune.Enabled = True
'    'fraTuningMethod.Enabled = True
'    'fraTauValue.Enabled = True
'    'txtStartTemp.Enabled = True
'    'txtStopTemp.Enabled = True
'    'txtCurrProt.Enabled = True
'    'txtVoltProt.Enabled = True
'    'txtUppLim.Enabled = True
'    'txtLowLim.Enabled = True
'    cmdOKGPIB.Enabled = True
'    cmdCancelGPIB.Enabled = True
'    cmdSaveSettings.Enabled = True

ok2510:
'    'set model type to 2510
'    intModel = int2510
'    'set model # text field to light green
'    txtModelNum.BackColor = &HAAFFAA
'    'set fwrev color to white
'    txtFWRev.BackColor = &HFFFFFF
'    cmdOKGPIB.Enabled = True
'    cmdCancelGPIB.Enabled = True
'    cmdSaveSettings.Enabled = True

other:
    txtModelNum.BackColor = &H1111FF            'Set model number background to red
    intModel = intOther
    cmdOKGPIB.Enabled = False
    cmdCancelGPIB.Enabled = True
    cmdSaveSettings.Enabled = False

fino:

End Sub

Private Sub Form_Unload(Cancel As Integer)
    Cancel = MsgBox("Exit?", 20, "Exit Verify")         'Confirm exit

If Cancel = 6 Then              'Quit application was chosen, close all potentially open forms
    Unload frmGPIBSettings
'    Unload frmAutotune
    End                         'Stop program execution
End If

End Sub

Private Sub txt2510GPIB_LostFocus()
'Ensure that chosen GPIB address is OK

If IsNumeric(txt2510GPIB.Text) Then
    If txt2510GPIB.Text > 30 Then
    MsgBox "Enter an address between 1 and 30"
    txt2510GPIB.Text = 30
    End If
    If txt2510GPIB.Text < 1 Then
    MsgBox "Enter an address between 1 and 30"
    txt2510GPIB.Text = 1
    End If

Else: MsgBox "Enter an address between 1 and 30"
txt2510GPIB.Text = 10

End If
End Sub

